package com.greensock.easing
{

    public class RoughEase extends Object
    {
        private var _name:String;
        private var _first:EasePoint;
        private var _last:EasePoint;
        private static var _lookup:Object = {};
        private static var _count:uint = 0;

        public function RoughEase(param1:Number = 1, param2:uint = 20, param3:Boolean = false, param4:Function = null, param5:String = "none", param6:Boolean = true, param7:String = "")
        {
            var _loc_10:Number = NaN;
            var _loc_11:Number = NaN;
            var _loc_12:Number = NaN;
            var _loc_13:Number = NaN;
            var _loc_14:Object = null;
            if (param7 == "")
            {
                this._name = "roughEase" + _count++;
            }
            else
            {
                this._name = param7;
                _lookup[this._name] = this;
            }
            if (param5 == "" || param5 == null)
            {
                param5 = "none";
            }
            var _loc_8:Array = [];
            var _loc_9:int = 0;
            param1 = param1 * 0.4;
            var _loc_15:* = param2;
            while (--_loc_15 > -1)
            {
                
                _loc_10 = param6 ? (Math.random()) : (1 / param2 * _loc_15);
                _loc_11 = param4 != null ? (this.param4(_loc_10, 0, 1, 1)) : (_loc_10);
                if (param5 == "none")
                {
                    _loc_12 = param1;
                }
                else if (param5 == "out")
                {
                    _loc_13 = 1 - _loc_10;
                    _loc_12 = (1 - _loc_10) * _loc_13 * param1;
                }
                else if (param5 == "in")
                {
                    _loc_12 = _loc_10 * _loc_10 * param1;
                }
                else if (_loc_10 < 0.5)
                {
                    _loc_13 = _loc_10 * 2;
                    _loc_12 = _loc_10 * 2 * _loc_13 * 0.5 * param1;
                }
                else
                {
                    _loc_13 = (1 - _loc_10) * 2;
                    _loc_12 = (1 - _loc_10) * 2 * _loc_13 * 0.5 * param1;
                }
                if (param6)
                {
                    _loc_11 = _loc_11 + (Math.random() * _loc_12 - _loc_12 * 0.5);
                }
                else if (_loc_15 % 2)
                {
                    _loc_11 = _loc_11 + _loc_12 * 0.5;
                }
                else
                {
                    _loc_11 = _loc_11 - _loc_12 * 0.5;
                }
                if (param3)
                {
                    if (_loc_11 > 1)
                    {
                        _loc_11 = 1;
                    }
                    else if (_loc_11 < 0)
                    {
                        _loc_11 = 0;
                    }
                }
                _loc_8[++_loc_9] = {x:_loc_10, y:_loc_11};
            }
            _loc_8.sortOn("x", Array.NUMERIC);
            var _loc_16:* = new EasePoint(1, 1, null);
            this._last = new EasePoint(1, 1, null);
            this._first = _loc_16;
            --_loc_15 = param2;
            while (--_loc_15 > -1)
            {
                
                _loc_14 = _loc_8[--_loc_15];
                this._first = new EasePoint(_loc_14.x, _loc_14.y, this._first);
            }
            this._first = new EasePoint(0, 0, this._first.time != 0 ? (this._first) : (this._first.next));
            return;
        }// end function

        public function ease(param1:Number, param2:Number, param3:Number, param4:Number) : Number
        {
            var _loc_6:EasePoint = null;
            var _loc_5:* = param1 / param4;
            if (param1 / param4 < 0.5)
            {
                _loc_6 = this._first;
                while (_loc_6.time <= _loc_5)
                {
                    
                    _loc_6 = _loc_6.next;
                }
                _loc_6 = _loc_6.prev;
            }
            else
            {
                _loc_6 = this._last;
                while (_loc_6.time >= _loc_5)
                {
                    
                    _loc_6 = _loc_6.prev;
                }
            }
            return param2 + (_loc_6.value + (_loc_5 - _loc_6.time) / _loc_6.gap * _loc_6.change) * param3;
        }// end function

        public function dispose() : void
        {
            delete _lookup[this._name];
            return;
        }// end function

        public function get name() : String
        {
            return this._name;
        }// end function

        public function set name(param1:String) : void
        {
            delete _lookup[this._name];
            this._name = param1;
            _lookup[this._name] = this;
            return;
        }// end function

        public static function create(param1:Number = 1, param2:uint = 20, param3:Boolean = false, param4:Function = null, param5:String = "none", param6:Boolean = true, param7:String = "") : Function
        {
            var _loc_8:* = new RoughEase(param1, param2, param3, param4, param5, param6, param7);
            return new RoughEase(param1, param2, param3, param4, param5, param6, param7).ease;
        }// end function

        public static function byName(param1:String) : Function
        {
            return _lookup[param1].ease;
        }// end function

    }
}

class EasePoint extends Object
{
    public var time:Number;
    public var gap:Number;
    public var value:Number;
    public var change:Number;
    public var next:EasePoint;
    public var prev:EasePoint;

    function EasePoint(param1:Number, param2:Number, param3:EasePoint)
    {
        this.time = param1;
        this.value = param2;
        if (param3)
        {
            this.next = param3;
            param3.prev = this;
            this.change = param3.value - param2;
            this.gap = param3.time - param1;
        }
        return;
    }// end function

}

